
***************************************************************
* Figure 11. Explaining Headline Inflation Shocks
***************************************************************

***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_monthly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

* Relative price fluctuations (supply fluctuations)
g z			= CPI - Median

* Redefine energy price inflation and food price inflation in relative terms (relative to median).

replace energy	= energy - Median
replace food	= food - Median
replace allcars	= allcars - Median

***************************************************************
* Explaining relative price fluctuations
***************************************************************

local latest = tm(2022m9)
local start = tm(2020m1)

preserve
local title = "Energy Prices"
local index = 2
cap drop z
g z = CPI - Median
g w = energy
local name = "Energy-price shocks (right)"
label variable w "`name'"
local label1 = "Headline-inflation shocks"
local label2 = "`name'"
local label3 = ""
local ytitle = ""
keep if t>=`start' & t<=`latest'
sum t
local t0 = r(min)
local t1 = r(max)-2
twoway ///
(line z t, title("`title'", size(median)) ytitle("`ytitle'") yline(0, lcolor(ebg)) lcolor(red) lwidth(medthick medthick) lpattern(dash)) ///
(line w t, lcolor(blue) lwidth(medthick medthick) lpattern(solid) yaxis(2) ytitle("", axis(2)) ///
xmtick(#32) xlabel(`t0'(12)`t1', format(%tmCY)) xtitle("") ///
legend(label(1 "`label1'") label(2 "`label2'") label(3 "`label3'") label(4 "`label4'")) ///
legend(row(3) symxsize(3) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(1 2 3)) ///
legend(size(small)) xsize(6) ///
saving(`index'.gph, replace) nodraw)
rename z Hshocks
rename w Energy
outsheet Hshocks Energy t using "results\charts\Figure 11 Panel B Energy.xls", replace
restore

* Headline inflation shocks, auto 
preserve
local title = "Auto-related Prices"
local index = 3
cap drop z
g z = CPI - Median
g w1 = allcars
local name1 = "Auto-related price shocks (right)"
label variable w1 "`name'"
local label1 = "Headline-inflation shocks"
local label2 = "`name1'"
local ytitle = ""
keep if t>=`start' & t<=`latest'
sum t
local t0 = r(min)
local t1 = r(max)-2
twoway ///
(line z t, title("`title'", size(median)) ytitle("`ytitle'") yline(0, lcolor(ebg)) lcolor(red) lwidth(medthick medthick) lpattern(dash)) ///
(line w1 t, lcolor(blue ebblue) lpattern(solid) lwidth(medthick medthick) yaxis(2) ytitle("", axis(2)) ///
xmtick(#32) xlabel(`t0'(12)`t1', format(%tmCY)) xtitle("") ///
legend(label(1 "`label1'") label(2 "`label2'")) ///
legend(row(3) symxsize(3) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(1 2 3)) ///
legend(size(small)) xsize(6) ///
saving(`index'.gph, replace) nodraw)
rename z Hshocks
rename w1 Autofo
outsheet Hshocks Auto t using "results\charts\Figure 11 Panel B Auto.xls", replace
restore

graph combine 2.gph 3.gph, row(3) ysize(7)


